<?PHP
/*
*****************************************
JSON to SQL table
json2table 0.4.0 19 June 025
El Condor - Condor Informatique - Turin
*****************************************
All scripts (SOFTWARE PRODUCT) are provided by El Condor "as is" and "with all faults."
El Condor makes no representations or warranties of any kind concerning the safety, suitability, lack of viruses,
inaccuracies, typographical errors, or other harmful components of this SOFTWARE PRODUCT.
There are inherent dangers in the use of any software, and you are solely responsible for determining whether this
SOFTWARE PRODUCT is compatible with your equipment and other software installed on your equipment.
You are also solely responsible for the protection of your equipment and backup of your data, and El Condor will not be liable
for any damages you may suffer in connection with using, modifying, or distributing this SOFTWARE PRODUCT.
You can use this SOFTWARE PRODUCT freely, if you would you can credit me in program comments:
El Condor – CONDOR INFORMATIQUE – Turin
Comments, suggestions and criticisms are welcomed: mail to rossati@libero.it
*/
class J2t {
	private static $types = array("array"=>"TEXT","integer"=>"INTEGER","string"=>"TEXT","double"=>"REAL");
	private static $reSquareBrackets = "/^\s*\[\s*{.*?}\s*\]\s*$/";
	private static $reCurlyBrackets = "/^\s*{.+?}\s*$/";
	public $newTable = false;	// if true the table is not temporary
	public static function execSQL($dbh,$sql,$parms=[]) {
		$errMode = $dbh->getAttribute(PDO::ATTR_ERRMODE);			// save previous ATTR_ERRMODE
		$dbh->setattribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_SILENT);	// disable crash
		$sth = $dbh->prepare($sql);
		$a = $dbh->errorInfo();
		$dbh->setattribute(PDO::ATTR_ERRMODE,$errMode);	// restore previous ATTR_ERRMODE
		if (!$sth) {return "\n<br>$sql\n<br>".$a[2];}
		$sth->execute($parms);
		return $sth;
	}
	public static function extractFields($row,$noJsonFields=[]) {	
		static $reStripSquare = "/^\s*\[|]\s*$/";
		if (gettype($row) == "string") {	// only one field
			$value = $row;
			if (preg_match(self::$reSquareBrackets,$value)) $value = preg_replace($reStripSquare,"",$value);
			$jsn = json_decode($value,true);
			if (json_last_error() != 0)	return [];
		} else {
			$json = [];
			foreach ($row as $key => $value) {
				if (preg_match(self::$reSquareBrackets,$value)) $value = preg_replace($reStripSquare,"",$value);
				if (preg_match(self::$reCurlyBrackets,$value)) {
					$jsn = json_decode($value,true);
					if (json_last_error() != 0)	return $json;
					foreach ($jsn as $k => $v) {
						if (isset($json[$k]) || in_array($k,$noJsonFields)) $json[$k."_".$key] = $v;	//has previous synonym
						else $json[$k] = $v;
						
					}
				} else {
					if (isset($json[$key])) {
						echo "CuCu $key $value\n";
					}
					$json[$key] = $value;
				}
			}
			$jsn = [];	// final data
			foreach ($json as $key => $v) {	// check subsequent synonyms
				if (is_array($v)) {
					foreach ($v as $k => $value) {
						if (!isset($json[$k]) || $k == $key) $jsn[$k] = $value;	// Json field name = table field name
						else {
							$jsn[$k."_".$key] = $value;
						}
					}
				} else $jsn[$key] = $v;
			}
		}
		return $jsn;
	}
	public function json2t($dbh,$result,$tableName="TemporaryTable",$flds = array()) {
		return self::json2table($dbh,$result,$tableName,$flds,$this);
	}
	public static function json2table($dbh,$result,$tableName="TemporaryTable",$flds = array(),$obj = null) {
		$server = $dbh->getAttribute(PDO::ATTR_DRIVER_NAME);
		switch ($server) {
			case "mysql" :
				$sql = "SHOW TABLES LIKE '$tableName'";
				$sth = self::execSQL($dbh,$sql);
				if (count($sth->fetchAll(PDO::FETCH_NUM)) > 0) return "Table $tableName exists";
				break;
			case "sqlite" :
				$sql = "SELECT name FROM sqlite_master WHERE type='table' AND name='$tableName'";
				$sth = self::execSQL($dbh,$sql);
				if (count($sth->fetchAll(PDO::FETCH_NUM)) > 0) return "Table $tableName exists";
				break;
		}
		if (gettype($flds) == "string") $flds = preg_split("/\s*,\s*/",$flds);
		$noJsonFields = [];
		if (!is_array($result)) {	// must be a SQL SELECT
			$sth = self::execSQL($dbh,$result);
			if (gettype($sth) == "string") return $sth;
			$result = $sth->fetchAll(PDO::FETCH_ASSOC);			
			foreach ($result[0] as $key => $value) {
				if (!preg_match(self::$reSquareBrackets,$value) && !preg_match(self::$reCurlyBrackets, $value)) $noJsonFields[] = $key;
			}
		}
		if (count($result) == 0) return "No data!";
		$errorTable = $tableName."_Errors";
		$sql = "CREATE TEMPORARY TABLE $errorTable (RowNumber INTEGER, Error TEXT, Row Text)";
		self::execSQL($dbh,$sql);		
		$json = self::extractFields($result[0],$noJsonFields);	
//		Determine the type of data
		foreach ($json as $key => $value) {
			$json[$key] = self::$types[gettype($value)];
		}
		if (count($flds) == 0) { // no fields indicated
			$flds = $json;
		} else if (isset($noJsonFields)) $flds = array_merge($flds, $noJsonFields);
		$aKeys = array_keys($json);	// for test presence of requested data
		$aSin = [];	// array of synonyms
		foreach ($flds as $key => $value) {
			if (is_int($key)) {
				$fieldValue = $value;
				$fields[$value] = isset($json[$value]) ? $json[$value] : "TEXT";
				if (!isset($json[$value])) {
					self::execSQL($dbh,"INSERT INTO $errorTable VALUES (?,?,?)",["","Undefined field \"$value\"",""]);
				}
			} else {
				$fieldValue = $key;
				$fields[$key] = $value;
				if (!isset($json[$key])) {
					self::execSQL($dbh,"INSERT INTO $errorTable VALUES (?,?,?)",["","Undefined field \"$key\"",""]);
				}
			}
			$r = preg_grep("/^$fieldValue"."_.+/", $aKeys);	// search synonyms
			if (count($r) > 0) {
				$sinKey = array_values($r)[0];
				$aSin[$sinKey] = $json[$sinKey];
			}
		}
		$flds = array_merge($fields, $aSin);
//		create table
		$a = [];
		foreach ($flds as $key => $value) {
			if (!is_int($key)) array_push($a,"$key $value");
		}
		$temp = $obj != null && $obj->newTable ? "" : "TEMPORARY";
		$sql = "CREATE $temp TABLE $tableName (".implode(",",$a).")";
		self::execSQL($dbh,$sql);
		$a = [];
		$count = 0;
		for ($i=0;$i<count($result);$i++) {		// loop on data array
			$count++;
			$json = self::extractFields($result[$i],$noJsonFields);
			if (json_last_error() != 0) {
				self::execSQL($dbh,"INSERT INTO $errorTable VALUES (?,?,?)",[$count,"JSON ".json_last_error_msg(),substr(var_export($result[$i],true),6)]);
			}
			$a = [];
			$v = [];
			foreach ($flds as $k => $vl) {	// search if exists field in data
				if (isset($json[$k])) {
					array_push($a,$k);
					if (gettype($json[$k]) == "array") $json[$k] = implode(", ",$json[$k]);
					array_push($v,$json[$k]);
				}
			}
			if (count($a) > 0) {
				$sql = "INSERT INTO $tableName (".implode(", ",$a). ") VALUES(".substr(str_repeat(",?",count($v)),1).")";
				$sth = self::execSQL($dbh,$sql,$v);
				if (gettype($sth) == "string")
					self::execSQL($dbh,"INSERT INTO $errorTable VALUES (?,?,?)",[$count,$sth,substr(var_export($result[$i],true),6)]);
			}
		}
		return "";
	}
}
?>